DECLARE SUB GRAPHWFM (IWFM%(), XI#)
DECLARE SUB WAIT.FOR.OPC (DIG!, OPC%)
DECLARE SUB WAIT.KEY (KEY$)
DECLARE SUB GND.REF (DIG!, YZ%)
DECLARE SUB SRQ (DIG!, STATUS%(), PAUSE%)
DECLARE SUB SWAP.BYTES (test%())
DECLARE FUNCTION MIN% (IWFM%(), MINLOC!)
DECLARE FUNCTION MAX% (IWFM%(), MAXLOC!)
DECLARE SUB REMOVE.DEFECT (DIG!)
DECLARE SUB SCALEWFM (YM!, YZ%, WFM!(), IWFM%())
DECLARE SUB DELAY (DELAYTIME!)
DECLARE SUB GETWFM (DIG!, IWFM%(), MODE$, FLAG!)
DECLARE SUB GETSCALE (DIG!, XI#, YM!, FLAG!)
DECLARE FUNCTION GETANS$ (MES$)
DECLARE SUB PRESS.ANY.KEY (MES$)
DECLARE SUB GPIB.WRITE (DIG!, MES$, FLAG!)
DECLARE SUB GPIB.READ (DIG!, RD$, FLAG!)
DECLARE FUNCTION STR2NUM! (SOURCE$, SRCH$)
DECLARE FUNCTION GETNUM% (MES$)

' PROGRAM TO ACQUIRE, SCALE & GRAPH A WAVEFORM FROM 7912HB/7912AD
' PROGRAMMABLE DIGITIZER USING 7929P/7919P VERTICAL PLUG IN & THE
' 7B90P TIMEBASE PLUG IN.  THIS PROGRAM ALSO REMOVES DEFECTS FOR THE
' 7912HB CRT AND ACQUIRES A GROUND REFERENCE.
'
'INSTRUMENT ADDRESS IS ASSUMED TO BE:
'       PRIMARY ADDRESS=0
'       SECONDARY ADDRESS=0
'
'
' Three variables are used by the National instruments GPIB driver to
' describe the status of GPIB operations (IBSTA, IBERR, & IBCNT).  The
' COMMON SHARED statement used depends on the version of Quickbasic. If you
' are using Quickbasic 4.0 or less, comment out the QB 4.5 COMMON statement
' and unremark the QB 4.0 or less COMMON statement below.

	COMMON SHARED /NISTATBLK/ IBSTA%, IBERR%, IBCNT%    'Quickbasic 4.5

	'COMMON SHARED IBSTA%, IBERR%, IBCNT%               'Quickbasic 4.0 or less

	COMMON SHARED TRUE, FALSE, FLAG, WFM.THERE, EGA%
	COMMON SHARED PRI%, SEC%, DIG, YM!, YZ%, XI#, KEY$
	  
	DIM SHARED IWFM(0 TO 511) AS INTEGER
	DIM SHARED WFM(0 TO 511) AS SINGLE
	DIM SHARED STATUS(0 TO 2) AS INTEGER

RESTART:
	PRI% = 0                        'DEFAULT PRIMARY ADDRESS
	SEC% = 0                        'DEFAULT SECONDARY ADDRESS
	TRUE = 1                        'SET FLAG = TRUE MEANS FLAG=1
	FALSE = 0                       'SET FLAG = FALSE MEANS FLAG=0
	FLAG = 0                        'FLAG USED FOR ERROR HANDLING
	YZ% = -1                        'GROUND REF UNDEFINED=-1
	WFM.THERE = 0                   'INITIALLY NO WAVEFORMS DEFINED
	EGA% = 1                        'SET EGA%=0 FOR CGA TERMINAL
	   
	ON ERROR GOTO General.error.handler

	CALL IBFIND("TEKDEV1", DIG)     'FIND 'TEKDEV1' IN GPIB.COM
	CALL IBPAD(DIG, PRI%)           'CHANGE PRIMARY ADDRESS
	CALL IBSAD(DIG, SEC% + 96)      'CHANGE SECONDARY ADDRESS
	CALL IBCLR(DIG)                 'SEND INTERFACE CLEAR TO CLEAN BUS
	CALL GPIB.WRITE(DIG, "OPC ON;XYZ ATC", FLAG)
MAINMENU:
	SCREEN 0
	CLS
	PRINT "               *** 7912HB IIG EXAMPLE PROGRAM MAIN MENU ***"
	PRINT
	PRINT " 1. Serial poll"
	PRINT " 2. Remove defects from 7912HB CRT"
	PRINT " 3. Enable/Disable ground reference"
	PRINT " 4. Acquire ATC waveform to memory"
	PRINT " 5. Acquire averaged waveform to memory"
	PRINT " 6. Graph waveform from memory"
	PRINT " 7. Exit program"
	TMP = 0
	'WHILE TMP < 1 OR TMP > 7
	PRINT : TMP = GETNUM("Enter choice (1 to 7)")
	'WEND
	SELECT CASE TMP
	CASE 7
		GOTO THEEND
	CASE 1
		CALL SRQ(DIG, STATUS%(), 1)
	CASE 2
		CALL REMOVE.DEFECT(DIG)
		CALL GPIB.WRITE(DIG, "XYZ ATC", FLAG)
	CASE 3
		CALL GND.REF(DIG, YZ%)
	CASE 4
		CALL PRESS.ANY.KEY("Ready to acquire a 7912HB ATC waveform")
		CALL GETSCALE(DIG, XI#, YM!, FLAG)
		PRINT "Reading a 512 point waveform"
		MODE$ = "MODE DIG;DIG DAT;ATC;READ ATC"
		CALL GETWFM(DIG, IWFM%(), MODE$, FLAG)
		FOR I% = 0 TO 511
		   IWFM%(I%) = IWFM%(I%) / 2 'divide values by 2 for atc wfm
		NEXT I%
		WFM.THERE = 1
		CALL SCALEWFM(YM!, YZ%, WFM(), IWFM%())
	CASE 5
		NUMAVG% = -1
	   WHILE NUMAVG% < 0 OR NUMAVG% > 64
		TMP% = GETNUM%("Enter number of averages (1, 2, 4, 8, 16, 32 or 64, 0 to exit)")
		IF TMP% = 0 THEN GOTO MAINMENU
		IF TMP% <> 1 AND TMP% <> 2 AND TMP% <> 4 AND TMP% <> 8 AND TMP% <> 16 AND TMP% <> 32 AND TMP% <> 64 THEN
			NUMAVG% = -1
		ELSE
			NUMAVG% = TMP%
		END IF
	   WEND
		CALL GETSCALE(DIG, XI#, YM!, FLAG)
		PRINT "Reading 512 point waveform averaged" + STR$(NUMAVG%) + " times";
		MODE$ = "MODE DIG;DIG SA," + MID$(STR$(NUMAVG%), 2, 4) + ";READ SA"
		CALL GETWFM(DIG, IWFM%(), MODE$, FLAG)
		FOR I% = 0 TO 511
		   IWFM%(I%) = IWFM%(I%) / NUMAVG% 'divide values by 2 for atc wfm
		NEXT I%
		WFM.THERE = 1
		CALL GPIB.WRITE(DIG, "XYZ SA", FLAG)
		CALL SCALEWFM(YM!, YZ%, WFM(), IWFM%()) '
	CASE 6
		IF WFM.THERE > 0 THEN
			CALL GRAPHWFM(IWFM%(), XI#)
		ELSE
			CALL PRESS.ANY.KEY("No waveforms acquired yet")
		END IF
	CASE ELSE
		GOTO MAINMENU
	END SELECT
		GOTO MAINMENU
THEEND:
	PRINT : PRINT "Program ended. "
	END

General.error.handler:
		SCREEN 0
		CLS
		PRINT "Unexpected Error #"; ERR
		PRINT
		PRINT "Please try to document the sequence of operations and conditions"
		PRINT "which led to this error.  This information is extremely valuable"
		PRINT "in trying to correct programming problems.  Use the Quickbasic"
		PRINT "manual for an explanation of the error number."
		PRINT
		PRINT "Press any key to restart the program..."

		WHILE INKEY$ > ""
		WEND
		DO
		LOOP UNTIL INKEY$ > ""
		RESUME RESTART

SUB DELAY (DELAYTIME!)
'SUB TO DELAY A SPECIFIC AMOUNT OF TIME
	START! = TIMER
	FINISH! = START! + DELAYTIME!
	DO
		DOTIME! = TIMER
	LOOP WHILE FINISH! - DOTIME! > 0
END SUB

FUNCTION GETANS$ (MES$)
'FUNCTION TO DISPLAY THE PROMPT IN 'MES$' AND RETURN A 'Y' (YES) OR 'N' (NO)
	ANS$ = SPACE$(1)
AGAIN:
	PRINT : PRINT MES$ + " (Y/N)";
	INPUT ANS$
	ANS$ = UCASE$(ANS$)
	IF ANS$ <> "N" AND ANS$ <> "Y" THEN GOTO AGAIN
	GETANS$ = ANS$
END FUNCTION

FUNCTION GETNUM% (MES$)
'FUNCTION TO DISPLAY THE PROMPT 'MES$' AND RETURN AN INTEGER NUMBER 'GETNUM%'
BADNUM:
	PRINT : PRINT MES$ + ": ";
	INPUT a$
	a$ = a$ + "-99"
	a% = VAL(a$)
	IF a% = -99 THEN GOTO BADNUM
	GETNUM% = a%
END FUNCTION

SUB GETSCALE (DIG, XI#, YM!, FLAG)
' SUB TO QUERY THE MAINFRAME FOR THE VERTICAL & HORIZONTAL SCALE FACTORS
'
	PRINT "Reading scale factors"
	MES$ = "VS1?"
	GOSUB GETSFCTR
	YM! = ANS# / 64!                  '64 LEVELS PER DIVISION (512/
	   
	MES$ = "HS1?"
	GOSUB GETSFCTR
	XI# = ANS# / 51.2                 '51.2 POINTS PER DIV (512/10 DIV)
	EXIT SUB

GETSFCTR:
	TMP$ = SPACE$(30)
	CALL GPIB.WRITE(DIG, MES$, FLAG)
	CALL GPIB.READ(DIG, TMP$, FLAG)
	TMP = INSTR(TMP$, " ")
	RD$ = MID$(TMP$, TMP, 15)
	ANS# = VAL(RD$)
	RETURN

END SUB

SUB GETWFM (DIG, IWFM%(), MODE$, FLAG) STATIC
' READS 7912HB WAVEFORM INTO INTEGER ARRAY 'IWFM%()'
' VARIABLE MODE$ CAN BE USED TO QUERY FOR ATC, SIGNAL AVGED, ETC WAVEFORMS
'

	CNT% = 1024
	CALL IBSAD(DIG, SEC% + 96)      'CHANGE SECONDARY ADDRESS
	HEADER$ = SPACE$(3)
	CHECKSUM$ = SPACE$(2)
	   
	CALL GPIB.WRITE(DIG, MODE$, FLAG)
	OPC% = 0
	WHILE OPC% < 1
		CALL WAIT.FOR.OPC(DIG, OPC%)   'wait until ready to send data
	WEND
	
	IF FLAG = FALSE THEN GOTO read.curve.error

	CALL GPIB.READ(DIG, HEADER$, FLAG)              ' read %bc
	IF IBSTA% < 0 THEN GOTO read.curve.error

	CALL IBRDI(DIG, IWFM%(), CNT%)                  ' READ CURVE
	IF IBSTA% < 0 THEN GOTO read.curve.error
	
	CALL IBRD(DIG, CHECKSUM$)                       ' read checksum ; <lf>
	IF IBSTA% < 0 THEN GOTO read.curve.error
	   
	CALL SWAP.BYTES(IWFM%())        ' swap high and low data bytes
	FLAG = TRUE
EXIT SUB
read.curve.error:
	FLAG = FALSE
	CALL PRESS.ANY.KEY("GPIB error reading waveform, IBSTA=$" + HEX$(IBSTA%) + ", IBERR=" + STR$(IBERR%) + ", IBCNT=" + STR$(IBCNT%))
	IBERR% = 0
END SUB

SUB GND.REF (DIG, YZ%)
' GROUNDS THE VERTICAL PLUG-IN AND READS THE GROUND TRACE.  THE GROUND LEVEL
' IS THEN USED FOR ALL SUBSEQUENT ACQUISITIONS UNTIL TURNED OFF.
'
	ANS$ = GETANS$("Define & use a ground reference for all subsequent acquisitions")
	IF ANS$ = "Y" THEN
		PRINT : PRINT "Reading ground reference....."
		CPL$ = SPACE$(20)
		MOD$ = SPACE$(20)
		
		CALL IBSAD(DIG, 97 + SEC%)              'SET SECONDARY ADDRESS TO VERT PLUG
		CALL GPIB.WRITE(DIG, "CPL?", FLAG)      'LEARN VERTICAL COUPLING
		CALL GPIB.READ(DIG, CPL$, FLAG)
		CPL$ = RTRIM$(CPL$)
		CALL GPIB.WRITE(DIG, "CPL GND", FLAG)   'GROUND VERTICAL PLUGIN
		  
		CALL IBSAD(DIG, 98 + SEC%)              'SET SECONDARY ADDRESS TO TIMEBASE PLUG
		CALL GPIB.WRITE(DIG, "MOD?", FLAG)      'LEARN VERTICAL COUPLING
		CALL GPIB.READ(DIG, MOD$, FLAG)
		MOD$ = RTRIM$(MOD$)
		CALL GPIB.WRITE(DIG, "MOD PPA", FLAG)   'SET TO PK-PK AUTO TRIGGER
		CALL DELAY(.5)                          'WAIT 500 mS
		  
		CALL GETWFM(DIG, IWFM%(), "MODE DIG;DIG DAT;ATC;READ ATC", FLAG)        'READ GND WAVEFORM
		  
		TMP% = 0                                'FIND MEAN OF 1ST 20 POINTS
		FOR I% = 1 TO 20
		TMP% = TMP% + IWFM%(I%)
		NEXT I%

		YZ% = TMP% / 20                         'YZ% IS GROUND REFERENCE
		YZ% = YZ% / 2                           'ATC WFM /2
		   
		CALL IBSAD(DIG, 97 + SEC%)              'SET SECONDARY ADDRESS TO VERTICAL PLUG
		CALL GPIB.WRITE(DIG, CPL$, FLAG)        'RESET COUPLING
		'CALL DELAY(2)
		CALL IBSAD(DIG, 98 + SEC%)              'SET SECONDARY ADDRESS TO TIMEBASE PLUG
		CALL GPIB.WRITE(DIG, MOD$, FLAG)        'RESET TIMEBASE TRIGGER MODE
		'CALL DELAY(2)
		CALL IBSAD(DIG, 96 + SEC%)
		
	ELSE
		YZ = -1                                 'NO GROUND REFERENCE
	END IF

	IF YZ% = -1 THEN TMP$ = "disabled" ELSE TMP$ = "enabled"
	CALL PRESS.ANY.KEY("Ground reference is " + TMP$)
	CALL GPIB.WRITE(DIG, "XYZ ATC;DIG DAT;ATC", FLAG)
	'CALL GPIB.WRITE(DIG, "DIG DAT;ATC", FLAG)
END SUB

SUB GPIB.READ (DIG, RD$, FLAG)
' READS A STRING FROM THE GPIB.  IF AN ERROR OCCURS, AN ERROR MESSAGE IS
' DISPLAYED AND THE VARIABLE 'FLAG' IS SET TO ZERO (FALSE).

	CALL IBRD(DIG, RD$)
	IF IBSTA% < 0 THEN
		FLAG = FALSE
		CALL PRESS.ANY.KEY("GPIB error on read, IBSTA=$" + HEX$(IBSTA%) + ", IBERR=" + STR$(IBERR%) + ", IBCNT=" + STR$(IBCNT%))
		IBERR% = 0
	ELSE
		FLAG = TRUE
	END IF
END SUB

SUB GPIB.WRITE (DIG, MES$, FLAG)
' WRITES A STRING FROM THE GPIB.  IF AN ERROR OCCURS, AN ERROR MESSAGE IS
' DISPLAYED AND THE VARIABLE 'FLAG' IS SET TO ZERO (FALSE).

	CALL IBWRT(DIG, MES$)
	IF IBSTA% < 0 THEN
		FLAG = FALSE
		CALL PRESS.ANY.KEY("GPIB error on write, IBSTA=$" + HEX$(IBSTA%) + ", IBERR=" + STR$(IBERR%) + ", IBCNT=" + STR$(IBCNT%))
		IBERR% = 0
	ELSE
		FLAG = TRUE
	END IF
END SUB

SUB GRAPHWFM (IWFM%(), XI#)
'GRAPHS ACQUIRED INTEGER WAVEFORM ARRAY ONTO PC MONITOR

	START = 0
	FINISH = 511
	AMAX% = MAX%(IWFM%(), MAXLOC)
	AMIN% = MIN%(IWFM%(), MINLOC)
	IF EGA% THEN
		SCREEN 9: CLS 0
		vpix% = 14
		VIEW (70, 2.5 * vpix%)-(570, 22.5 * vpix%), , 1
	ELSE
		SCREEN 2: CLS 0
		vpix% = 8
		VIEW (70, 2.5 * vpix%)-(570, 22.5 * vpix%), , 1
	END IF
	WINDOW (START - 10, AMIN% - (AMIN% / 10))-(FINISH + 10, AMAX% + (AMAX% / 10))
	PSET (START, IWFM%(START))
	FOR I% = START + 1 TO FINISH
		LINE -(I%, IWFM%(I%))
	NEXT I%
	LOCATE 1, 1
	CALL PRESS.ANY.KEY("TO RETURN TO MAIN MENU")
END SUB

FUNCTION MAX% (IWFM%(), MAXLOC)
' FIND MAXIMUM VALUE OF AN INTEGER ARRAY AND IT'S LOCATION IN THE ARRAY
	first% = LBOUND(IWFM%)
	last% = UBOUND(IWFM%)
	TMAX% = IWFM%(first%)
	MAXLOC = first%
	FOR I% = first% + 1 TO last%
	   IF IWFM%(I%) > TMAX% THEN
		TMAX% = IWFM%(I%)
		MAXLOC = I%
	   END IF
	NEXT I%
	MAX% = TMAX%
END FUNCTION

FUNCTION MIN% (IWFM%(), MINLOC)
'FIND MINIMUM VALUE OF AN INTEGER ARRAY AND IT'S LOCATION IN THE ARRAY
	first% = LBOUND(IWFM%)
	last% = UBOUND(IWFM%)
	TMIN% = IWFM%(first%)
	MINLOC = first%
	FOR I% = first% + 1 TO last%
	   IF IWFM%(I%) < TMIN% THEN
		TMIN% = IWFM%(I%)
		MINLOC = I%
	   END IF
	NEXT I%
	MIN% = TMIN%
END FUNCTION

SUB PRESS.ANY.KEY (MES$)
' PRINT MESSAGE AND WAIT UNTIL ANY KEY IS PRESSED

	PRINT : PRINT MES$
	PRINT "Press <Space Bar> to continue"
	CALL WAIT.KEY(KEY$)
END SUB

SUB REMOVE.DEFECT (DIG)
' USES THE 'DIGITIZE DEFECTS' COMMAND TO REMOVE ANY DIODES THAT DO NOT
' TURN OFF.  REMOVES SPIKES FROM THE ACQUIRED DATA DO TO BAD DIODES.

	PRINT : PRINT "Removing any defects from 7912HB CRT";
	CALL IBSAD(DIG, 96 + 0)
	CALL GPIB.WRITE(DIG, "DIG DEF,1024;DEF ON", FLAG)
	OPC% = 0
	WHILE OPC% < 1
		CALL WAIT.FOR.OPC(DIG, OPC%)
	WEND
	
	CALL GPIB.WRITE(DIG, "XYZ ATC;DIG DAT;ATC", FLAG)
END SUB

SUB SCALEWFM (YM!, YZ%, WFM(), IWFM%())
'SUB TO SCALE THE INTEGER ARRAY IWFM$() INTO A VOLTAGE ARRAY WFM()
'USING THE YMULITPLIER 'YM!' AND THE GROUND REFERENCE 'YZ%' (IF DEFINED)

	PRINT "Scaling waveform into a voltage array"
	IF YZ% > -1 THEN YZERO% = YZ% ELSE YZERO% = 0  'IF GND REF DEFINED THEN USE
	FOR I% = 0 TO 511
		WFM(I%) = (IWFM%(I%) - YZERO%) * YM!
	NEXT I%
END SUB

SUB SRQ (DIG, STATUS%(), PAUSE%)
' CLEAR SRQ'S FROM MAINFRAME, VERTICAL PLUG-IN, & TIMEBASE PLUG-IN AND
' RETURN THE STATUS BYTES IN VARIABLE 'STATUS%()'.
' STATUS%(0) = MAINFRAME STATUS
' STATUS%(1) = VERTICAL STATUS
' STATUS%(2) = TIMEBASE STATUS
' VARIABLE PAUSE% TELLS THIS SUB TO PRINT STATUS AND WAIT FOR USER KEY PRESS

   FOR I% = 0 TO 2
	CALL IBSAD(DIG, 96 + I%)
	CALL IBRSP(DIG, STATUS%(I%))
	IF IBSTA% < 0 THEN
		FLAG = FALSE
		CALL PRESS.ANY.KEY("ERROR HANDLING SRQ, IBSTA= $" + HEX$(IBSTA%) + ", IBERR=" + STR$(IBERR%) + ", IBCNT=" + STR$(IBCNT%))
		IBERR% = 0
	END IF
   NEXT I%
   IF PAUSE% = 1 THEN
   CALL PRESS.ANY.KEY("MAINFRAME SRQ:" + STR$(STATUS%(0)) + ", VERTICAL PLUGGIN SRQ:" + STR$(STATUS%(1)) + ", TIMEBASE SRQ:" + STR$(STATUS%(2)))
   END IF
END SUB

FUNCTION STR2NUM (SOURCE$, SRCH$)
' FUNCTION TO RETURN A NUMBER FROM A STRING.  USEFUL FOR PARSING WAVEFORM
' PREAMBLE FOR VALUES

	STATIC POSIT%, TMP$
	POSIT% = INSTR(SOURCE$, SRCH$) + LEN(SRCH$) + 1
	TMP$ = MID$(SOURCE$, POSIT%, 15)
	STR2NUM = VAL(TMP$)

END FUNCTION

SUB SWAP.BYTES (test%()) STATIC
' SWAPS HIGH & LOW BYTES OF AN INTEGER NUMBER

	FOR I% = 0 TO 511
	tempbyte% = test%(I%) AND &HFF00
	IF tempbyte% < 0 THEN
		tempbyte% = ((tempbyte% AND &H7F00) \ 256) OR &H80
	ELSE
		tempbyte% = tempbyte% \ 256
	END IF
	test%(I%) = ((test%(I%) AND &HFF) * 256) + tempbyte%
	NEXT I%
END SUB

SUB WAIT.FOR.OPC (DIG, OPC%)
' WAIT UNTIL THE 7912HB ISSUES AN OPERATION COMPLETE  (OPC) SRQ

	STAT% = 0       'WAIT TILL 7912 IS READY TO SEND WAVEFORM
			'WAIT FOR OPC (OPERATION COMPLETE)
	CALL IBRSP(DIG, STAT%)
	IF STAT% <> 66 AND STAT% <> 2 AND STAT% <> 82 AND STAT% <> 18 THEN
		OPC% = 0
		PRINT ".";
		CALL DELAY(.1)
	ELSE
		OPC% = 1
		PRINT
	END IF
END SUB

SUB WAIT.KEY (KEY$) STATIC
' WAIT UNTIL A KEY IS PRESSED

	WHILE INKEY$ > ""    ' flush out pending keystrokes
	WEND
	DO
		KEY$ = INKEY$
	LOOP UNTIL KEY$ > ""
END SUB

